#!/bin/sh
#
# Copyright (C) 2024, 2025 Mikulas Patocka
#
# This file is part of Ajla.
#
# Ajla is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# Ajla is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# Ajla. If not, see <https://www.gnu.org/licenses/>.

set -e

cat <<EOF >version.h
/*
 * No-copyright
 * A table of numbers, generated by a script, is supposedly not copyrightable.
 */

EOF
sed -n 's/AC_INIT(ajla, \(.*\))/\#define AJLA_VERSION "\1"/p' <configure.ac >>version.h

FILES_INSTALL="`echo builtin.pcd terminfo stdlib/*.ajla stdlib/*/*.ajla stdlib/*/*/*.ajla charsets/*.c8`"
FILES_DIST="`echo newlib/*.ajla newlib/*/*.ajla newlib/*/*/*.ajla scripts/*.* scripts/*/*.* programs/test/*.ajla programs/acmd/*.ajla texts/tutorial.html texts/*.dia texts/*.svg`"
cat Makefile.t | sed "s=FILES_INSTALL=$FILES_INSTALL=g" | sed "s=FILES_DIST=$FILES_DIST=g" >Makefile.am

aclocal -I m4
autoheader
automake -ac
autoconf
./fixup-configure
