/*
 * No-copyright
 * A table of numbers, generated by a script, is supposedly not copyrightable.
 */

#ifndef AJLA_PCODE_OP_H
#define AJLA_PCODE_OP_H

#define P_BinaryOp			1
#define P_BinaryConstOp			2
#define P_UnaryOp			3
#define P_Copy				4
#define P_Copy_Type_Cast		5
#define P_Free				6
#define P_Eval				7
#define P_Keep				8
#define P_Where				9
#define P_Value				10
#define P_Fn				11
#define P_Load_Local_Type		12
#define P_Load_Fn			13
#define P_Curry				14
#define P_Call				15
#define P_Call_Indirect			16
#define P_Load_Const			17
#define P_Structured_Write		18
#define P_Record_Type			19
#define P_Option_Type			20
#define P_Record_Create			21
#define P_Record_Load_Slot		22
#define P_Record_Load			23
#define P_Option_Create			24
#define P_Option_Load			25
#define P_Option_Test			26
#define P_Option_Ord			27
#define P_Array_Flexible		28
#define P_Array_Fixed			29
#define P_Array_Create			30
#define P_Array_Fill			31
#define P_Array_String			32
#define P_Array_Unicode			33
#define P_Array_Load			34
#define P_Array_Len			35
#define P_Array_Len_Finite		36
#define P_Array_Len_Greater_Than	37
#define P_Array_Sub			38
#define P_Array_Skip			39
#define P_Array_Append			40
#define P_Array_Append_One		41
#define P_Array_Flatten			42
#define P_Array_Is_Finite		43
#define P_Read_Clock			44
#define P_Jmp				45
#define P_Jmp_False			46
#define P_Label				47
#define P_IO				48
#define P_Args				49
#define P_Return_Vars			50
#define P_Return_Vars_Inlined		51
#define P_Return			52
#define P_Assume			53
#define P_Claim				54
#define P_Invariant			55
#define P_ForAll			56
#define P_Checkpoint			57
#define P_Line_Info			58
#define P_Phi				59
#define P_Pcode_N			60

#define T_Type				-1
#define T_SInt8				-2
#define T_UInt8				-3
#define T_SInt16			-4
#define T_UInt16			-5
#define T_SInt32			-6
#define T_UInt32			-7
#define T_SInt64			-8
#define T_UInt64			-9
#define T_SInt128			-10
#define T_UInt128			-11
#define T_Integer			-12
#define T_Integer8			-13
#define T_Integer16			-14
#define T_Integer32			-15
#define T_Integer64			-16
#define T_Integer128			-17
#define T_Real16			-18
#define T_Real32			-19
#define T_Real64			-20
#define T_Real80			-21
#define T_Real128			-22
#define T_Bool				-23
#define T_EmptyOption			-24
#define T_Undetermined			-25
#define T_TypeOfType			-26
#define T_Record			-27
#define T_UnknownType			-28
#define T_InvalidType			-29
#define T_InferredType			-30

#define Structured_Record		1
#define Structured_Option		2
#define Structured_Array		3

#define VarFlag_Must_Be_Flat		1
#define VarFlag_Must_Be_Data		2
#define VarFlag_Specialize		4

#define Flag_Free_Argument		1
#define Flag_Evaluate			2
#define Flag_Borrow			4
#define Flag_Array_Fill_Sparse		8
#define Flag_Op_Strict			16
#define Flag_Return_Elided		32
#define Flag_Index_In_Range		64
#define Flag_Fused_Bin_Jmp		128
#define Flag_Spec			256
#define Flag_NoSpec			512

#define Bin_Add				0
#define Bin_Subtract			1
#define Bin_Multiply			2
#define Bin_Divide_Int			3
#define Bin_Divide_Real			4
#define Bin_Modulo			5
#define Bin_Power			6
#define Bin_Atan2			7
#define Bin_And				8
#define Bin_Or				9
#define Bin_Xor				10
#define Bin_Shl				11
#define Bin_Shr				12
#define Bin_Rol				13
#define Bin_Ror				14
#define Bin_Bts				15
#define Bin_Btr				16
#define Bin_Btc				17
#define Bin_Equal			18
#define Bin_NotEqual			19
#define Bin_Less			20
#define Bin_LessEqual			21
#define Bin_Greater			22
#define Bin_GreaterEqual		23
#define Bin_Bt				24
#define Un_Not				25
#define Un_Neg				26
#define Un_Bswap			27
#define Un_Brev				28
#define Un_Bsf				29
#define Un_Bsr				30
#define Un_Popcnt			31
#define Un_Sqrt				32
#define Un_Cbrt				33
#define Un_Sin				34
#define Un_Cos				35
#define Un_Tan				36
#define Un_Asin				37
#define Un_Acos				38
#define Un_Atan				39
#define Un_Sinh				40
#define Un_Cosh				41
#define Un_Tanh				42
#define Un_Asinh			43
#define Un_Acosh			44
#define Un_Atanh			45
#define Un_Exp2				46
#define Un_Exp				47
#define Un_Exp10			48
#define Un_Log2				49
#define Un_Log				50
#define Un_Log10			51
#define Un_Round			52
#define Un_Floor			53
#define Un_Ceil				54
#define Un_Trunc			55
#define Un_Fract			56
#define Un_Mantissa			57
#define Un_Exponent			58
#define Un_NextNumber			59
#define Un_PrevNumber			60
#define Un_ConvertToInt			61
#define Un_ConvertFromInt		62
#define Un_IsException			63
#define Un_ExceptionClass		64
#define Un_ExceptionType		65
#define Un_ExceptionAux			66
#define Un_SystemProperty		67
#define Op_N				68

#define Fn_Function			1
#define Fn_Record			2
#define Fn_Option			3
#define Fn_Mask				3
#define Fn_AutoInline			4
#define Fn_IsFlatOption			8
#define Fn_AlwaysFlatOption		16
#define Fn_NoVerify			32
#define Fn_Specialize			64

#define Local_Type_Record		0
#define Local_Type_Option		1
#define Local_Type_Array		2
#define Local_Type_Flat_Record		3
#define Local_Type_Flat_Array		4

#define Call_Mode_Unspecified		0
#define Call_Mode_Normal		1
#define Call_Mode_Strict		2
#define Call_Mode_Spark			3
#define Call_Mode_Weakspark		4
#define Call_Mode_Lazy			5
#define Call_Mode_Inline		6
#define Call_Mode_Cache			7
#define Call_Mode_Save			8
#define Call_Mode_Flat			9

#define SystemProperty_OS		1
#define SystemProperty_Charset		2
#define SystemProperty_Charset_Console	3
#define SystemProperty_Fixed		4
#define SystemProperty_Real		5
#define SystemProperty_Privileged	6
#define SystemProperty_Sandbox		7
#define SystemProperty_Compile		8
#define SystemProperty_NoInline		9
#define SystemProperty_Verify		10
#define SystemProperty_Verify_Timeout	11

#define SystemProperty_OS_Posix		1
#define SystemProperty_OS_DOS		2
#define SystemProperty_OS_OS2		3
#define SystemProperty_OS_Cygwin	4
#define SystemProperty_OS_Windows	5

#define IO_Exception_Make		0
#define IO_Exception_String		1
#define IO_Exception_Payload		2
#define IO_Exception_Stack		3
#define IO_N_Std_Handles		4
#define IO_Get_Std_Handle		5
#define IO_Get_Args			6
#define IO_Get_Environment		7
#define IO_Stream_Open_Read		8
#define IO_Stream_Read_Partial		9
#define IO_Stream_Open_Write		10
#define IO_Stream_Write			11
#define IO_Read_Console_Packet		12
#define IO_Write_Console_Packet		13
#define IO_Pipe				14
#define IO_Block_Open			15
#define IO_Block_Read			16
#define IO_Block_Write			17
#define IO_LSeek			18
#define IO_FTruncate			19
#define IO_FAllocate			20
#define IO_CloneRange			21
#define IO_FSync			22
#define IO_Sync				23
#define IO_Root_Dir			24
#define IO_Lib_Path			25
#define IO_Open_Dir			26
#define IO_Read_Dir			27
#define IO_Dir_Path			28
#define IO_DMonitor_Prepare		29
#define IO_DMonitor_Wait		30
#define IO_Stat				31
#define IO_FStat			32
#define IO_FStatFS			33
#define IO_DStatFS			34
#define IO_ReadLink			35
#define IO_Dir_Action			36
#define IO_Dir2_Action			37
#define IO_Drives			38
#define IO_Stty				39
#define IO_Tty_Size			40
#define IO_Tty_Background		41
#define IO_Tty_Foreground		42
#define IO_UName			43
#define IO_GetHostName			44
#define IO_Spawn			45
#define IO_Wait				46
#define IO_GetTime			47
#define IO_TimeToCalendar		48
#define IO_CalendarToTime		49
#define IO_Sleep			50
#define IO_Any				51
#define IO_Never			52
#define IO_Fork				53
#define IO_Atomic_Enter			54
#define IO_Atomic_Exit			55
#define IO_Wait_For_Dereferenced	56
#define IO_Int_To_Native		57
#define IO_Native_To_Int		58
#define IO_Socket			59
#define IO_Connect			60
#define IO_Connect_Wait			61
#define IO_Bind				62
#define IO_Listen			63
#define IO_Accept			64
#define IO_Get_Sock_Name		65
#define IO_Get_Peer_Name		66
#define IO_Recv_From			67
#define IO_Send_To			68
#define IO_Get_Sock_Opt			69
#define IO_Set_Sock_Opt			70
#define IO_Get_Addr_Info		71
#define IO_Get_Name_Info		72
#define IO_MsgQueue_New			73
#define IO_MsgQueue_Send		74
#define IO_MsgQueue_Receive		75
#define IO_MsgQueue_Wait		76
#define IO_MsgQueue_Is_Nonempty		77
#define IO_Signal_Handle		78
#define IO_Signal_Prepare		79
#define IO_Signal_Wait			80
#define IO_Consume_Parameters		81
#define IO_Load_Program			82
#define IO_Get_Function_Ptr		83
#define IO_Get_SubFunctions		84
#define IO_Load_Optimized_Pcode		85
#define IO_Register_Dependence		86
#define IO_Deep_Eval			87
#define IO_Evaluate			88
#define IO_Debug			89
#define IO_StackTrace			90
#define IO_TraceCtl			91
#define IO_Get_Dump			92
#define IO_FFI_Get_Size_Alignment	93
#define IO_FFI_Create_Structure		94
#define IO_FFI_Structure_Offset		95
#define IO_FFI_Poke			96
#define IO_FFI_Peek			97
#define IO_FFI_Poke_Array		98
#define IO_FFI_Peek_Array		99
#define IO_FFI_Handle_To_Number		100
#define IO_FFI_Number_To_Handle		101
#define IO_FFI_Open_Library		102
#define IO_FFI_Create_Function		103
#define IO_FFI_Call_Function		104
#define IO_FFI_Encode_Real		105
#define IO_FFI_Decode_Real		106
#define IO_FFI_Destructor_New		107
#define IO_FFI_Destructor_Allocate	108
#define IO_FFI_Destructor_Free		109
#define IO_FFI_Destructor_Call		110
#define IO_N				111

#define IO_Open_Flag_Read		1
#define IO_Open_Flag_Write		2
#define IO_Open_Flag_Append		4
#define IO_Open_Flag_Create		8
#define IO_Open_Flag_Must_Create	16
#define IO_Open_Flag_No_Follow		32
#define IO_Open_Flag_N			64

#define IO_Stat_Flag_DevMajor		1
#define IO_Stat_Flag_DevMinor		2
#define IO_Stat_Flag_Inode		4
#define IO_Stat_Flag_Type		8
#define IO_Stat_Flag_Mode		16
#define IO_Stat_Flag_NLink		32
#define IO_Stat_Flag_UID		64
#define IO_Stat_Flag_GID		128
#define IO_Stat_Flag_RDevMajor		256
#define IO_Stat_Flag_RDevMinor		512
#define IO_Stat_Flag_Size		1024
#define IO_Stat_Flag_OptimalIOSize	2048
#define IO_Stat_Flag_Allocated		4096
#define IO_Stat_Flag_ATime		8192
#define IO_Stat_Flag_MTime		16384
#define IO_Stat_Flag_CTime		32768

#define IO_Stat_Type_File		1
#define IO_Stat_Type_Directory		2
#define IO_Stat_Type_Link		3
#define IO_Stat_Type_Pipe		4
#define IO_Stat_Type_CharDev		5
#define IO_Stat_Type_BlockDev		6
#define IO_Stat_Type_Socket		7

#define IO_StatFS_Flag_BSize		1
#define IO_StatFS_Flag_FrSize		2
#define IO_StatFS_Flag_FrTotal		4
#define IO_StatFS_Flag_FrFree		8
#define IO_StatFS_Flag_FrAvail		16
#define IO_StatFS_Flag_InTotal		32
#define IO_StatFS_Flag_InFree		64
#define IO_StatFS_Flag_InAvail		128
#define IO_StatFS_Flag_FSId		256
#define IO_StatFS_Flag_Flags		512
#define IO_StatFS_Flag_NameLen		1024

#define IO_StatFS_ST_ReadOnly		1
#define IO_StatFS_ST_NoSuid		2
#define IO_StatFS_ST_NoDev		4
#define IO_StatFS_ST_NoExec		8
#define IO_StatFS_ST_Synchronous	16
#define IO_StatFS_ST_MandLock		32
#define IO_StatFS_ST_NoAtime		64
#define IO_StatFS_ST_NoDirAtime		128
#define IO_StatFS_ST_RelAtime		256

#define IO_UName_Flag_Ajla_Version	1
#define IO_UName_Flag_Flavor		2
#define IO_UName_Flag_System		4
#define IO_UName_Flag_Release		8
#define IO_UName_Flag_Version		16
#define IO_UName_Flag_Machine		32

#define IO_Action_Rm			1
#define IO_Action_Rm_Dir		2
#define IO_Action_Mk_Dir		3
#define IO_Action_Mk_Pipe		4
#define IO_Action_Mk_Socket		5
#define IO_Action_Mk_CharDev		6
#define IO_Action_Mk_BlockDev		7
#define IO_Action_Mk_SymLink		8
#define IO_Action_Mk_Link		9
#define IO_Action_Rename		10
#define IO_Action_ChMod			11
#define IO_Action_ChOwn			12
#define IO_Action_LChOwn		13
#define IO_Action_UTime			14
#define IO_Action_LUTime		15

#define IO_Stty_Flag_Raw		1
#define IO_Stty_Flag_Noecho		2
#define IO_Stty_Flag_Nosignal		4
#define IO_Stty_Flag_NoCRLF		8

#define EC_NONE				0
#define EC_SYNC				1
#define EC_ASYNC			2
#define EC_SYSCALL			3
#define EC_LIBRARY			4
#define EC_EXIT				5
#define EC_N				6

#define AJLA_ERROR_BASE			1
#define AJLA_ERROR_UNKNOWN_ERROR	1
#define AJLA_ERROR_OUT_OF_MEMORY	2
#define AJLA_ERROR_SIZE_OVERFLOW	3
#define AJLA_ERROR_INT_TOO_LARGE	4
#define AJLA_ERROR_DOESNT_FIT		5
#define AJLA_ERROR_INVALID_OPERATION	6
#define AJLA_ERROR_NOT_SUPPORTED	7
#define AJLA_ERROR_NEGATIVE_INDEX	8
#define AJLA_ERROR_INDEX_OUT_OF_RANGE	9
#define AJLA_ERROR_OPTION_DOESNT_MATCH	10
#define AJLA_ERROR_RECORD_FIELD_NOT_INITIALIZED 11
#define AJLA_ERROR_ARRAY_ENTRY_NOT_INITIALIZED 12
#define AJLA_ERROR_NOT_FOUND		13
#define AJLA_ERROR_NON_ABSOLUTE_PATH	14
#define AJLA_ERROR_ABORT		15
#define AJLA_ERROR_NAN			16
#define AJLA_ERROR_INFINITY		17
#define AJLA_ERROR_SYSTEM_RETURNED_INVALID_DATA 18
#define AJLA_ERROR_COMPILER_ERROR	19
#define AJLA_ERROR_OPTIMIZER_ERROR	20
#define AJLA_ERROR_SANDBOX_VIOLATION	21
#define AJLA_ERROR_SYSTEM		22
#define AJLA_ERROR_ERRNO		23
#define AJLA_ERROR_OS2			24
#define AJLA_ERROR_OS2_SOCKET		25
#define AJLA_ERROR_WIN32		26
#define AJLA_ERROR_H_ERRNO		27
#define AJLA_ERROR_GAI			28
#define AJLA_ERROR_SUBPROCESS		29
#define AJLA_ERROR_LIBRARY_NOT_FOUND	30
#define AJLA_ERROR_SYMBOL_NOT_FOUND	31
#define AJLA_ERROR_EXIT			32
#define AJLA_ERROR_USER			33
#define AJLA_ERROR_USER2		34
#define AJLA_ERROR_USER3		35
#define AJLA_ERROR_N			36

#define SYSTEM_ERROR_BASE		1
#define SYSTEM_ERROR_EPERM		1
#define SYSTEM_ERROR_ENOENT		2
#define SYSTEM_ERROR_ESRCH		3
#define SYSTEM_ERROR_EINTR		4
#define SYSTEM_ERROR_EIO		5
#define SYSTEM_ERROR_ENXIO		6
#define SYSTEM_ERROR_E2BIG		7
#define SYSTEM_ERROR_ENOEXEC		8
#define SYSTEM_ERROR_EBADF		9
#define SYSTEM_ERROR_ECHILD		10
#define SYSTEM_ERROR_EAGAIN		11
#define SYSTEM_ERROR_ENOMEM		12
#define SYSTEM_ERROR_EACCES		13
#define SYSTEM_ERROR_EFAULT		14
#define SYSTEM_ERROR_ENOTBLK		15
#define SYSTEM_ERROR_EBUSY		16
#define SYSTEM_ERROR_EEXIST		17
#define SYSTEM_ERROR_EXDEV		18
#define SYSTEM_ERROR_ENODEV		19
#define SYSTEM_ERROR_ENOTDIR		20
#define SYSTEM_ERROR_EISDIR		21
#define SYSTEM_ERROR_EINVAL		22
#define SYSTEM_ERROR_ENFILE		23
#define SYSTEM_ERROR_EMFILE		24
#define SYSTEM_ERROR_ENOTTY		25
#define SYSTEM_ERROR_ETXTBSY		26
#define SYSTEM_ERROR_EFBIG		27
#define SYSTEM_ERROR_ENOSPC		28
#define SYSTEM_ERROR_ESPIPE		29
#define SYSTEM_ERROR_EROFS		30
#define SYSTEM_ERROR_EMLINK		31
#define SYSTEM_ERROR_EPIPE		32
#define SYSTEM_ERROR_EDOM		33
#define SYSTEM_ERROR_ERANGE		34
#define SYSTEM_ERROR_EDEADLK		35
#define SYSTEM_ERROR_ENAMETOOLONG	36
#define SYSTEM_ERROR_ENOLCK		37
#define SYSTEM_ERROR_ENOSYS		38
#define SYSTEM_ERROR_ENOTEMPTY		39
#define SYSTEM_ERROR_ELOOP		40
#define SYSTEM_ERROR_ENOMSG		41
#define SYSTEM_ERROR_EIDRM		42
#define SYSTEM_ERROR_ECHRNG		43
#define SYSTEM_ERROR_EL2NSYNC		44
#define SYSTEM_ERROR_EL3HLT		45
#define SYSTEM_ERROR_EL3RST		46
#define SYSTEM_ERROR_ELNRNG		47
#define SYSTEM_ERROR_EUNATCH		48
#define SYSTEM_ERROR_ENOCSI		49
#define SYSTEM_ERROR_EL2HLT		50
#define SYSTEM_ERROR_EBADE		51
#define SYSTEM_ERROR_EBADR		52
#define SYSTEM_ERROR_EXFULL		53
#define SYSTEM_ERROR_ENOANO		54
#define SYSTEM_ERROR_EBADRQC		55
#define SYSTEM_ERROR_EBADSLT		56
#define SYSTEM_ERROR_EBFONT		57
#define SYSTEM_ERROR_ENOSTR		58
#define SYSTEM_ERROR_ENODATA		59
#define SYSTEM_ERROR_ETIME		60
#define SYSTEM_ERROR_ENOSR		61
#define SYSTEM_ERROR_ENONET		62
#define SYSTEM_ERROR_ENOPKG		63
#define SYSTEM_ERROR_EREMOTE		64
#define SYSTEM_ERROR_ENOLINK		65
#define SYSTEM_ERROR_EADV		66
#define SYSTEM_ERROR_ESRMNT		67
#define SYSTEM_ERROR_ECOMM		68
#define SYSTEM_ERROR_EPROTO		69
#define SYSTEM_ERROR_EMULTIHOP		70
#define SYSTEM_ERROR_EDOTDOT		71
#define SYSTEM_ERROR_EBADMSG		72
#define SYSTEM_ERROR_EOVERFLOW		73
#define SYSTEM_ERROR_ENOTUNIQ		74
#define SYSTEM_ERROR_EBADFD		75
#define SYSTEM_ERROR_EREMCHG		76
#define SYSTEM_ERROR_ELIBACC		77
#define SYSTEM_ERROR_ELIBBAD		78
#define SYSTEM_ERROR_ELIBSCN		79
#define SYSTEM_ERROR_ELIBMAX		80
#define SYSTEM_ERROR_ELIBEXEC		81
#define SYSTEM_ERROR_EILSEQ		82
#define SYSTEM_ERROR_ERESTART		83
#define SYSTEM_ERROR_ESTRPIPE		84
#define SYSTEM_ERROR_EUSERS		85
#define SYSTEM_ERROR_ENOTSOCK		86
#define SYSTEM_ERROR_EDESTADDRREQ	87
#define SYSTEM_ERROR_EMSGSIZE		88
#define SYSTEM_ERROR_EPROTOTYPE		89
#define SYSTEM_ERROR_ENOPROTOOPT	90
#define SYSTEM_ERROR_EPROTONOSUPPORT	91
#define SYSTEM_ERROR_ESOCKTNOSUPPORT	92
#define SYSTEM_ERROR_EOPNOTSUPP		93
#define SYSTEM_ERROR_EPFNOSUPPORT	94
#define SYSTEM_ERROR_EAFNOSUPPORT	95
#define SYSTEM_ERROR_EADDRINUSE		96
#define SYSTEM_ERROR_EADDRNOTAVAIL	97
#define SYSTEM_ERROR_ENETDOWN		98
#define SYSTEM_ERROR_ENETUNREACH	99
#define SYSTEM_ERROR_ENETRESET		100
#define SYSTEM_ERROR_ECONNABORTED	101
#define SYSTEM_ERROR_ECONNRESET		102
#define SYSTEM_ERROR_ENOBUFS		103
#define SYSTEM_ERROR_EISCONN		104
#define SYSTEM_ERROR_ENOTCONN		105
#define SYSTEM_ERROR_ESHUTDOWN		106
#define SYSTEM_ERROR_ETOOMANYREFS	107
#define SYSTEM_ERROR_ETIMEDOUT		108
#define SYSTEM_ERROR_ECONNREFUSED	109
#define SYSTEM_ERROR_EHOSTDOWN		110
#define SYSTEM_ERROR_EHOSTUNREACH	111
#define SYSTEM_ERROR_EALREADY		112
#define SYSTEM_ERROR_EINPROGRESS	113
#define SYSTEM_ERROR_ESTALE		114
#define SYSTEM_ERROR_EUCLEAN		115
#define SYSTEM_ERROR_ENOTNAM		116
#define SYSTEM_ERROR_ENAVAIL		117
#define SYSTEM_ERROR_EISNAM		118
#define SYSTEM_ERROR_EREMOTEIO		119
#define SYSTEM_ERROR_EDQUOT		120
#define SYSTEM_ERROR_ENOMEDIUM		121
#define SYSTEM_ERROR_EMEDIUMTYPE	122
#define SYSTEM_ERROR_ECANCELED		123
#define SYSTEM_ERROR_ENOKEY		124
#define SYSTEM_ERROR_EKEYEXPIRED	125
#define SYSTEM_ERROR_EKEYREVOKED	126
#define SYSTEM_ERROR_EKEYREJECTED	127
#define SYSTEM_ERROR_EOWNERDEAD		128
#define SYSTEM_ERROR_ENOTRECOVERABLE	129
#define SYSTEM_ERROR_ERFKILL		130
#define SYSTEM_ERROR_EHWPOISON		131
#define SYSTEM_ERROR_N			132

#endif
